/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.Blocks.BlockEntity.Ports;

import com.hoshino.cti.Blocks.BlockEntity.Ports.BasicPort;
import com.hoshino.cti.Blocks.BlockEntity.Ports.PortType;
import com.hoshino.cti.Blocks.BlockEntity.Ports.TransferType;
import com.hoshino.cti.util.ctiEnergyStore;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public class EnergyOutputPortBE
extends BasicPort {
    @NotNull
    public final ctiEnergyStore energyStorage;
    private LazyOptional<IEnergyStorage> energyOptional = LazyOptional.empty();

    public EnergyOutputPortBE(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState, int energyStorage) {
        super(pType, pPos, pBlockState, PortType.ENERGY, TransferType.OUTPUT);
        this.energyStorage = new ctiEnergyStore(energyStorage, energyStorage){

            @Override
            public void onEnergyChange() {
                EnergyOutputPortBE.this.m_6596_();
            }

            public boolean canReceive() {
                return false;
            }
        };
    }

    public void onLoad() {
        super.onLoad();
        this.energyOptional = LazyOptional.of(() -> this.energyStorage);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.energyOptional.invalidate();
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        this.energyStorage.writeToNbt(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.energyStorage.readFromNbt(pTag);
    }

    @Override
    public void tick() {
        BlockEntity controller;
        super.tick();
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (this.controllerPos != null && (controller = this.f_58857_.m_7702_(this.f_58858_)) != null) {
            controller.getCapability(ForgeCapabilities.ENERGY).filter(IEnergyStorage::canExtract).ifPresent(energyHandler -> {
                int extract = Math.min(energyHandler.extractEnergy(energyHandler.getEnergyStored(), true), this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergy());
                if (extract > 0) {
                    energyHandler.extractEnergy(extract, false);
                    this.energyStorage.setEnergy(this.energyStorage.getEnergyStored() + extract);
                }
            });
        }
        for (Direction direction : List.of(Direction.UP, Direction.DOWN, Direction.EAST, Direction.NORTH, Direction.SOUTH, Direction.WEST)) {
            int energyToOutput = this.energyStorage.getEnergy();
            if (energyToOutput <= 0) {
                return;
            }
            BlockPos relative = this.f_58858_.m_121945_(direction);
            BlockEntity blockEntity = this.f_58857_.m_7702_(relative);
            if (blockEntity == null) continue;
            blockEntity.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).filter(IEnergyStorage::canReceive).ifPresent(energyHandler -> {
                int insert = Math.min(this.energyStorage.extractEnergy(energyToOutput, true), energyHandler.receiveEnergy(energyToOutput, true));
                if (insert > 0) {
                    energyHandler.receiveEnergy(insert, false);
                    this.energyStorage.extractEnergy(insert, false);
                }
            });
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyOptional.cast();
        }
        return super.getCapability(cap);
    }
}

